/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.icon;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopIcon;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopItemIcon
extends AbstractShopIcon {
    private ItemStack itemStack;
    private Icon icon;

    public ShopItemIcon(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.icon = ItemIcon.getItemIcon((ItemStack)itemStack);
    }

    @Override
    public void draw(PoseStack graphics, int x, int y, int width, int height) {
        this.icon.draw(graphics, x, y, width, height);
    }

    @Override
    public AbstractShopIcon copy() {
        return new ShopItemIcon(this.itemStack);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        NBTUtils.putItemStack(tag, "item", this.itemStack);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStack = NBTUtils.getItemStack(nbt, "item");
        this.icon = ItemIcon.getItemIcon((ItemStack)this.itemStack);
    }

    @Override
    public String getId() {
        return "itemIcon";
    }

    public String toString() {
        return "ShopItemIcon{itemStack=" + String.valueOf(this.itemStack) + "}";
    }

    public static class ShopItemIconC
    implements IConstructor<AbstractShopIcon> {
        @Override
        public AbstractShopIcon createDefaultInstance() {
            return new ShopItemIcon(Items.f_42127_.m_7968_());
        }
    }
}

